# Getting phpgeo

## Requirements

Minimum required PHP version is 8.1. *phpgeo* is tested up to PHP 8.3.

New features will only go into the main branch and won't be backported.

It's possible to install previous versions of *phpgeo* for older PHP versions.
Please refer to the following table for the compatibility matrix:

### Compatibility Matrix

| PHP Version | phpgeo Version |   Support Status   | Composer Install                        |
| :---------: | :------------: | :----------------: | --------------------------------------- |
|     8.3     |      5.x       |     ✅ active      | `composer require mjaschen/phpgeo`      |
|     8.2     |      5.x       |     ✅ active      | `composer require mjaschen/phpgeo`      |
|     8.1     |      5.x       |     ✅ active      | `composer require mjaschen/phpgeo`      |
|     8.0     |      4.x       | ⚠️ security only | `composer require mjaschen/phpgeo:^4.0` |
|     7.4     |      4.x       | ⚠️ security only | `composer require mjaschen/phpgeo:^4.0` |
|     7.3     |      4.x       | ⚠️ security only | `composer require mjaschen/phpgeo:^4.0` |
|     7.2     |      3.x       |   ❌ end of life   | `composer require mjaschen/phpgeo:^3.0` |
|     7.1     |      2.x       |   ❌ end of life   | `composer require mjaschen/phpgeo:^2.0` |
|     7.0     |      2.x       |   ❌ end of life   | `composer require mjaschen/phpgeo:^2.0` |
|     5.6     |      1.x       |   ❌ end of life   | `composer require mjaschen/phpgeo:^1.0` |
|     5.5     |      1.x       |   ❌ end of life   | `composer require mjaschen/phpgeo:^1.0` |
|     5.4     |      1.x       |   ❌ end of life   | `composer require mjaschen/phpgeo:^1.0` |

## Installation

*phpgeo* is best be installed using Composer. Please visit the
[Composer website](https://getcomposer.org/) for more information.

To install *phpgeo,* simply “require” it using Composer:

``` shell
composer require mjaschen/phpgeo
```

*phpgeo* is now ready to be used in your project!
